from bpy.types import PropertyGroup
from bpy.props import BoolProperty


class FLUIDLAB_PG_toggles(PropertyGroup):
    """ PARA LOS COLLAPSABLES """

    show_hide_presets: BoolProperty(default=False)
    fluids_list: BoolProperty(default=True)
    
    listados: BoolProperty(default=True)
    module_selector: BoolProperty(default=False)

    # Fluid Settings Emission:
    fs_emission_emission: BoolProperty(default=True)
    fs_emission_soft: BoolProperty(default=True)

    fs_emission_velocity: BoolProperty(default=True)
    fs_emission_viewport_display: BoolProperty(default=True)
    
    # Fluid Settings Physics:
    fs_integration: BoolProperty(default=True)
    fs_physics: BoolProperty(default=True)
    fs_physics_advanced_behavior: BoolProperty(default=True)
    field_weights: BoolProperty(default=False)

    # Fluid Settings Springs:
    fs_springs: BoolProperty(default=True)

    # Fluid Settings Animations:
    fs_emission_anim: BoolProperty(default=False)
    fs_emission_anim_object_anim_factor_x: BoolProperty(default=False)
    fs_emission_anim_object_anim_factor_y: BoolProperty(default=False)
    fs_emission_anim_object_anim_factor_z: BoolProperty(default=False)

    fs_physics_anim: BoolProperty(default=False)
    fs_physics_anim_timestep: BoolProperty(default=False)
    fs_physics_anim_subframes: BoolProperty(default=False)
    fs_physics_anim_stiffness: BoolProperty(default=False)
    fs_physics_anim_linear_viscosity: BoolProperty(default=False)
    fs_physics_anim_fluid_radius: BoolProperty(default=False)
    
    fs_springs_anim: BoolProperty(default=False)
    fs_springs_anim_spring_force: BoolProperty(default=False)
    fs_springs_anim_use_viscoelastic_springs: BoolProperty(default=False)

    fs_weights_anim: BoolProperty(default=False)
    fs_weights_anim_all: BoolProperty(default=False)
    fs_weights_anim_force: BoolProperty(default=False)
    fs_weights_anim_vortex: BoolProperty(default=False)
    fs_weights_anim_magnetic: BoolProperty(default=False)
    fs_weights_anim_harmonic: BoolProperty(default=False)
    fs_weights_anim_charge: BoolProperty(default=False)
    fs_weights_anim_lennardjones: BoolProperty(default=False)
    fs_weights_anim_wind: BoolProperty(default=False)
    fs_weights_anim_curve_guide: BoolProperty(default=False)
    fs_weights_anim_texture: BoolProperty(default=False)
    fs_weights_anim_smokeflow: BoolProperty(default=False)
    fs_weights_anim_turbulence: BoolProperty(default=False)
    fs_weights_anim_drag: BoolProperty(default=False)
    fs_weights_anim_boid: BoolProperty(default=False)
    fs_weights_anim_gravity: BoolProperty(default=False)

    fs_geometry_emitter_anim: BoolProperty(default=False)

    # Forces Animation:
    forces_strength_anim: BoolProperty(default=False)
    forces_size_anim: BoolProperty(default=False)
    forces_flow_anim: BoolProperty(default=False)
    forces_guide_free_anim: BoolProperty(default=False)
    forces_falloff_power_anim: BoolProperty(default=False)
    forces_linear_drag_anim: BoolProperty(default=False)
    forces_quadratic_drag_anim: BoolProperty(default=False)
    forces_harmonic_damping_anim: BoolProperty(default=False)
    forces_rest_length_anim: BoolProperty(default=False)

    # Colliders Settings:
    cs_collider_settings: BoolProperty(default=True)

    # Colliders Animation:
    ca_colliders_anim_permeability: BoolProperty(default=False)
    ca_colliders_anim_stickiness: BoolProperty(default=False)
    ca_colliders_anim_damping_factor: BoolProperty(default=False)
    ca_colliders_anim_friction_factor: BoolProperty(default=False)
    ca_colliders_anim_enable_disable: BoolProperty(default=False)

    # Render:
    rendering_viewport_settings: BoolProperty(default=True)
    rendering_viewport_display: BoolProperty(default=True)
    rendering_material_display: BoolProperty(default=True)
    rendering_settings: BoolProperty(default=True)
    rendering_world_settings: BoolProperty(default=True)
    hdr_img_collapsable: BoolProperty(default=True)

    # Mesh:
    mesh_settings: BoolProperty(default=True)
    motion_blur: BoolProperty(default=False)
    grain_settings: BoolProperty(default=True)


    # Force:
    force_settings: BoolProperty(default=True)
    force_falloff_settings: BoolProperty(default=True)
    force_p_settings: BoolProperty(default=True)
    force_p_falloff_settings: BoolProperty(default=True)
    force_c_settings: BoolProperty(default=True)
    force_c_falloff_settings: BoolProperty(default=True)
    force_kink: BoolProperty(default=True)


    # Shading:
    color_ramp: BoolProperty(default=True)
    pointiness_ramp: BoolProperty(default=False)
    water_light_mask_map_range: BoolProperty(default=False)
    mask_vel_map_range: BoolProperty(default=True)
    roughcomp: BoolProperty(default=False)
    cramp_pointiness: BoolProperty(default=False)

    # Shading, cycles lava:
    cl_uv_vector_switch: BoolProperty(default=True)
    cl_main: BoolProperty(default=False)
    cl_ctrls: BoolProperty(default=True)
    cl_lifetime_or_velocity: BoolProperty(default=True)
    cl_lifetime: BoolProperty(default=False)
    cl_velocity: BoolProperty(default=False)


    # Dynamic Paint
    canvas_settings: BoolProperty(default=True)
    surface_settings: BoolProperty(default=True)
    initial_color: BoolProperty(default=False)
    cache_settings: BoolProperty(default=True)
    output_settings: BoolProperty(default=True)
    brush_settings: BoolProperty(default=True)
    brush_source: BoolProperty(default=True)
    brush_velocity: BoolProperty(default=False)
    brush_velocity_ramp: BoolProperty(default=False)
    brush_velocity_smudge: BoolProperty(default=False)
    brush_waves: BoolProperty(default=False)
    canvas_effects: BoolProperty(default=False)
    canvas_effects_weights: BoolProperty(default=False)


    